import alice.logictuple.*;
import alice.tucson.api.*;
import java.io.BufferedInputStream;
import java.io.*;
import java.util.*;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;

/**
 * Classe che implementa il server. Si occupa di gestire la chat e 
 * il quiz
 *
 * @author  Rossella Rubino
 *
 */
public class ChatServer {
	private static QuizManager qm;
	
	public ChatServer(AgentId aid,TupleCentreId chatId,TupleCentreId q,TupleCentreId cr, 
		TupleCentreId qr,TupleCentreId p,TupleCentreId pr){
		try{
			new ObserverJoin(aid,chatId,cr).start();
			new ObserverLeave(aid,chatId,q,cr,qr).start();
			this.qm=new QuizManager(aid,q,qr,p,pr);
			this.qm.start();	   		
            		
		}
		catch(Exception ex){
			System.out.println("Oops, got exception! " + ex.getMessage());
	    	ex.printStackTrace();
	    	System.exit(1);	
	    	
		}
		
	}
	
	/*metodo usato per eliminare gli apici all'inizio e alla fine di una stringa
	 *
	 *@param st stringa su cui lavorare
	 *@return stringa senza apici
	 */
    private static String toFlatString(String st){
    	if (st.startsWith("'")&&st.endsWith("'")){
        	return st.substring(1,st.length()-1);
        } 
        else return st;
            
   }

    public static void main (String args[]) throws Exception {
        	
        if (args.length!=2){
            System.err.println("args: <indirizzo IP del nodo TuCSoN dove risiede il servizio di chat> <indirizzo IP del nodo TuCSoN di riserva>");
            System.exit(-1);
        }
        TupleCentreId chatId=new TupleCentreId("chat_room @ '"+args[0]+"'");
        TupleCentreId quizId=new TupleCentreId("quiz @ '"+args[0]+"'"); 
        TupleCentreId chatIdR=new TupleCentreId("chat_room @ '"+args[1]+"'");
        TupleCentreId quizIdR=new TupleCentreId("quiz @ '"+args[1]+"'");   
        
        TupleCentreId pool=new TupleCentreId("pool @ '"+args[0]+"'");  
        TupleCentreId poolR=new TupleCentreId("pool @ '"+args[1]+"'");            
        
        AgentId aid=new AgentId("server");
		TucsonContext context=Tucson.enterContext(new DefaultContextDescription(aid));
				
     	InputStream is = ClassLoader.getSystemResourceAsStream("rdall.rsp");
     	BufferedInputStream in = new BufferedInputStream(is);
     				
     	String txt = alice.util.Tools.loadText(in);
     	  
     	//associa la reazione ai centri di tuple chat e quiz su entrambi i nodi
     	try{
     		context.setSpec(chatId,txt); 
     		context.setSpec(quizId,txt);  
     	}
     	
     	catch(UnreachableNodeException une){}
    	try{
    		context.setSpec(chatIdR,txt);
    		context.setSpec(quizIdR,txt); 
    	}
    	catch(UnreachableNodeException une){}
     
		new ChatServer(aid,chatId,quizId,chatIdR,quizIdR,pool,poolR);
		
		/*inserisce la tupla relativa al conteggio degli utenti se non c' gi
		 *su entrambi i nodi*
		 */
		try{
			LogicTuple c=context.rdp(chatId, LogicTuple.parse("countUser(_)"));
			if (c==null){
				LogicTuple count=LogicTuple.parse("countUser(0)");
				context.out(chatId,count);
			}
		}
		catch(UnreachableNodeException une){
    		System.out.println("Nodo "+ args[0]+" non raggiungibile...disponibile "+ args[1]); 
    	}
    	
    	try{
			LogicTuple c2=context.rdp(chatIdR, LogicTuple.parse("countUser(_)"));
			if (c2==null){
				LogicTuple count=LogicTuple.parse("countUser(0)");
				context.out(chatIdR,count);
			}
		}
		catch(UnreachableNodeException une){
    		System.out.println("Nodo "+ args[1]+" non raggiungibile...disponibile "+ args[0]); 
    	}
    	
    	//gestione messaggi
    	while (true){          	       
        	
        	LogicTuple temp=LogicTuple.parse("msg(_,_,_,_)");
        	
        	try{
        		LogicTuple lt;
        		
        		try{
       				lt=context.in(chatId,temp);
       			}
       			catch(UnreachableNodeException une){}
       			try{
       				lt=context.in(chatIdR,temp);
       			}
       			catch(UnreachableNodeException une){
       				lt=context.in(chatId,temp);
       			}
       			String from=lt.getArg(0).getArg(0).toString();
       			String host=lt.getArg(1).getArg(0).toString();
       			String text=lt.getArg(2).getArg(0).toString();
       			String ts=lt.getArg(3).getArg(0).toString();
       		       		
       			System.out.println(from.substring(1,from.length()-1)+"> "+text);       		      
       		
       			if (text.equals("quizStart")){
       				System.out.println(from.substring(1,from.length()-1)+" partecipa al quiz");
       				try{
       					LogicTuple nuq=LogicTuple.parse("user("+from+",_,_,_)");
       					try{
			        		lt=context.inp(quizId,nuq);			        
			        	}
			        	catch(UnreachableNodeException une){}
			        	try{
			        		lt=context.inp(quizIdR,nuq);			        
			        	}
			        	catch(UnreachableNodeException une){
			        		lt=context.inp(quizId,nuq);
			        	}
		       			String score=lt.getArg(2).getArg(0).toString();
			        	nuq=LogicTuple.parse("user("+from+",host("+host+"),score("+score+"),status(online))");
	        			try{
	        				context.out(quizId,nuq); 
	        			}
	        			catch(UnreachableNodeException une){}
	        			try{
	        				context.out(quizIdR,nuq); 
	        			}
	        			catch(UnreachableNodeException une){}
       				}
       				catch(NullPointerException npe){
       					LogicTuple nuq=LogicTuple.parse("user("+from+",host("+host+"),score('0'),status(online))");
		       		 	try{
		       		 		context.out(quizId,nuq);
		       		 	}
		       		 	catch(UnreachableNodeException une){}
		       		 	try{
		       		 		context.out(quizIdR,nuq);
		       		 	}
		       		 	catch(UnreachableNodeException une){}
       				}
		    	}
		    	else{
		    		if (text.equals("quizStop")){
		    			/*l'utente non partecipa al quiz*/
	        			LogicTuple luq=LogicTuple.parse("user("+from+",_,_,_)");
	        			LogicTuple l;
	        			try{
	        				l=context.in(quizId,luq);   
	        			}
	        			catch(UnreachableNodeException une){}
	        			try{
	        				l=context.in(quizIdR,luq);   
	        			}
	        			catch(UnreachableNodeException une){
	        				l=context.in(quizId,luq); 
	        			}
	        			
	        			String score=luq.getArg(2).getArg(0).toString();	        		
	        			luq=LogicTuple.parse("user("+from+",host("+host+"),score('"+score+"'),status(offline))");
	        			try{
	        				context.out(quizId,luq); 		    		
	        			}
	        			catch(UnreachableNodeException une){}
	        			try{
	        				context.out(quizIdR,luq); 		    		
	        			}
	        			catch(UnreachableNodeException une){}
		        	}       			
       				else{
       					
       					String answer=qm.getCurrentAnswer();
       					
       					
       					if (text.equals(answer)){
       						qm.win(from.substring(1,from.length()-1));       					
       					}       	
       					else{			
       				
	       					Var vt=new Var("Lista");
							LogicTuple tupletemplateEnv=LogicTuple.parse("user(_,_)");	        			
							LogicTuple tlist;
							Term t=null;
							try{
								tlist=context.in(chatId,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt));
								t=vt.toTerm();
							}
							catch(UnreachableNodeException une){}
							
							Var vt2=new Var("Lista");					
							try{
								tlist=context.in(chatIdR,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt2));
								t=vt2.toTerm();
							}
							catch(UnreachableNodeException une){}
							
							alice.tuprolog.Var head;					
							Struct lista = (Struct)	t.getTerm();
										
							while (!lista.unify(new Struct())) {
								head = new alice.tuprolog.Var("Head");
								alice.tuprolog.Var tail = new alice.tuprolog.Var("Tail");
								boolean res = lista.unify(new Struct(head,tail));
								lista = (Struct) tail.getTerm();
						
								String tupla=head.toString();										
								LogicTuple ust=LogicTuple.parse(tupla);	
				
								String usr=ust.getArg(1).getArg(0).toString();
								String hostUser=toFlatString(ust.getArg(1).getArg(1).toString());	
			
								TupleCentreId userTC=new TupleCentreId(usr.toLowerCase()+" @ '"+hostUser+"'");
            							
								context.out(userTC,temp);
							
							}
						}
					}
    			}
    		}
    		catch(Exception e){
    			e.printStackTrace();
    		}    			   		
    	}
    }	
}


